//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "draw.h"

void drawLives(){

	u8 x,y;

	for(y=0;y<2;y++){

		for(x=0;x<lives - 1;x++){

			drawClippedSpriteOnBuffer(G_sinSangre, 27 + (12 * x), 199 - 20, 5, 14, g_scrbuffers[y]);

		}

		while(x < MAX_LIVES - 1){

			drawClippedSpriteOnBuffer(G_sangre, 27 + (12 * x), 199 - 20, 5, 14, g_scrbuffers[y]);
			x++;
		}

	}


}

void clearBullets(Bullet *bullet){

	u8 x = MAX_BULLETS;

	while(x--){

		bullet->active = FALSE;
		bullet++;

	}
}

void updateScoreboard(){

	drawNumber(score, 4, 8, MAX_Y + 18, 2, g_scrbuffers[1]);
	drawNumber(enemiesToKill, 2, 16, MAX_Y + 56, 2, g_scrbuffers[1]);

	drawNumber(score, 4, 8, MAX_Y + 18, 2, g_scrbuffers[0]);
	drawNumber(enemiesToKill, 2, 16, MAX_Y + 56, 2, g_scrbuffers[0]);
}


void generateGift(Entity *enemy, Entity *enemies){

	u8 x = cpct_rand() % 100;

	if(x > 60 && lives < MAX_LIVES) addEntity(ENEMY_TYPE_COKE,  enemy->xPos + enemy->width/2 - ENEMY_COKE_W/2,  enemy->yPos + ENEMY_BARREL_H - ENEMY_COKE_H , 0, enemies, 100);
	else if(x > 40) addEntity(ENEMY_TYPE_MONEY, enemy->xPos + enemy->width/2 - ENEMY_MONEY_W/2, enemy->yPos + ENEMY_BARREL_H - ENEMY_MONEY_H , 0, enemies, 100);



}

void drawHero(Entity *hero, Entity *target, Bullet *enemyBullets, u8 draw){

	u8 *pvideo = cpct_getScreenPtr(g_scrbuffers[1], hero->xPos, hero->yPos);

	if(draw){

		switch (hero->state) {

			case HERO_STATE_ON_FLOOR:

				if(hero->cycles < 4){
					cpct_drawSpriteMaskedAlignedTable(G_daniel1, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);
				}
				else {
					cpct_drawSpriteMaskedAlignedTable(G_daniel2, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);
				}

				if(++hero->cycles == 8) hero->cycles = 0;

				break;

			case HERO_STATE_GOING_LEFT:
			case HERO_STATE_GOING_RIGHT:

				if(hero->cycles < 2){
					cpct_drawSpriteMaskedAlignedTable(G_danielRun1, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);
				}
				else {
					cpct_drawSpriteMaskedAlignedTable(G_danielRun2, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);
				}

				if(++hero->cycles == 4) hero->cycles = 0;

				break;

			case HERO_STATE_FIRING:


				if(target->xPos < hero->xPos - TARGET_W){

					if(hero->cycles < 2){
						cpct_drawSpriteMaskedAlignedTable(G_danielFireL1, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);
					}
					else{
						cpct_drawSpriteMaskedAlignedTable(G_danielFireL2, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);
					}
				}

				else if(target->xPos > hero->xPos + HERO_W + TARGET_W){

					if(hero->cycles < 2){
						cpct_drawSpriteMaskedAlignedTable(G_danielFireR1, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);
					}
					else{
						cpct_drawSpriteMaskedAlignedTable(G_danielFireR2, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);
					}
				}
				else {

					if(hero->cycles < 2){
						cpct_drawSpriteMaskedAlignedTable(G_danielFireC1, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);

					}
					else{
						cpct_drawSpriteMaskedAlignedTable(G_danielFireC2, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);
					}

				}

				if(++hero->cycles == 4) hero->cycles = 0;

				break;


			case HERO_STATE_HIT:

				if(hero->cycles < 4){
					cpct_drawSpriteMaskedAlignedTable(G_danielMuerte1, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);
				}

				if(++hero->cycles == 4){
					hero->state = HERO_STATE_DEAD;
					hero->cycles = 0;
				}


				break;

			case HERO_STATE_DEAD:

				if(hero->cycles < 8){
					cpct_drawSpriteMaskedAlignedTable(G_danielMuerte2, pvideo, HERO_W, HERO_H, g_transparencyMaskTable);
				}

				if(++hero->cycles == 8){
					hero->state = HERO_STATE_ON_FLOOR;
					hero->cycles = 0;

					clearBullets(enemyBullets);
					drawBullets(enemyBullets, FALSE);

					if(--lives == 0) gameOver = TRUE;
					drawLives();

				}

				break;

		}

	}
	else{

		eraseClippedSprite(hero->pxPos, hero->yPos, HERO_W, HERO_H);

	}

}

void drawTarget(Entity *target, u8 draw){

	if(draw){

		drawClippedSprite(G_mirilla, target->xPos, target->yPos, TARGET_W, TARGET_H);

	}
	else{

		eraseClippedSprite(target->pxPos, target->pyPos, TARGET_W, TARGET_H);

	}

}



void drawEnemies(Entity *enemy, u8 draw, Entity *hero, Bullet *bullets){

	u8 max = MAX_ENEMIES;

	while(max){

		if(draw){

			switch (enemy->state) {

				case ENEMY_STATE_ACTIVE:

					if(enemy->cycles < 2){
						drawClippedSprite(enemy->xSpeed > 0 ? enemy->frame1 : enemy->frame3, enemy->xPos, enemy->yPos, enemy->width, enemy->height);
					}
					else {
						drawClippedSprite(enemy->xSpeed > 0 ? enemy->frame2 : enemy->frame4, enemy->xPos, enemy->yPos, enemy->width, enemy->height);
					}

					if(++enemy->cycles == 4) enemy->cycles = 0;

					break;

				case ENEMY_STATE_FIRE:

					if(enemy->cycles < 2){
						drawClippedSprite(enemy->frame5, enemy->xPos, enemy->yPos, enemy->width, enemy->height);
					}
					else if(enemy->cycles < 4){
						drawClippedSprite(enemy->frame6, enemy->xPos, enemy->yPos, enemy->width, enemy->height);
					}
					else {
						drawClippedSprite(enemy->frame5, enemy->xPos, enemy->yPos, enemy->width, enemy->height);
					}

					if(enemy->cycles == 2) fire(bullets, enemy->xPos + enemy->width/2, enemy->yPos + enemy->height /2, hero->xPos + hero->width /2 , (level > 3 && enemy->type == ENEMY_TYPE_LEJOS) || enemy->type == ENEMY_TYPE_WINDOW);

					if(++enemy->cycles == 6){

						enemy->state = ENEMY_STATE_ACTIVE;
						enemy->cycles = 0;

					}

					break;

				case ENEMY_STATE_EXPLOSION_A:

					drawClippedSprite(enemy->frame7, enemy->xPos, enemy->yPos, enemy->width, enemy->height);

					if(enemy->type < ENEMY_TYPE_WINDOW){

						drawClippedSprite(G_explosionb, enemy->xPos + enemy->width/2 - EXPLOSION_W/2, enemy->yPos + enemy->height - EXPLOSION_H, EXPLOSION_W, EXPLOSION_H);
					}

					break;

				case ENEMY_STATE_EXPLOSION_B:

					if(enemy->type < ENEMY_TYPE_WINDOW){

						drawClippedSprite(G_explosiona, enemy->xPos, enemy->yPos, EXPLOSION_W, EXPLOSION_H);

					}
					else{

						drawClippedSprite(enemy->frame7, enemy->xPos, enemy->yPos, enemy->width, enemy->height);
					}

					break;

				case ENEMY_STATE_EXPLOSION_C:

					if(enemy->type < ENEMY_TYPE_WINDOW){
						drawClippedSprite(G_explosionb, enemy->xPos, enemy->yPos, EXPLOSION_W, EXPLOSION_H);
					}
					else{

						drawClippedSprite(enemy->frame8, enemy->xPos, enemy->yPos, enemy->width, enemy->height);
					}

					break;

			}

		}
		else{

			if(((enemy->xSpeed != 0) || (enemy->xSpeed == 0 && enemy->state != ENEMY_STATE_ACTIVE))
			&& (enemy->pstate != ENEMY_STATE_INACTIVE)) eraseClippedSprite(enemy->pxPos, enemy->pyPos, (enemy->width < EXPLOSION_W ? EXPLOSION_W : enemy->width), (enemy->height < EXPLOSION_H ? EXPLOSION_H : enemy->height));


		}

		enemy++; max--;
	}

}

u8 moveEnemies(Entity *enemies, Entity *target, Entity *hero, cpct_keyID fire, u8 protection){

	u8* tilemap = G_levelTilemaps + (level - 1) * 20 * 16;
	u8 x = MAX_ENEMIES;
	u8 fliped = FALSE;

	u8 tile;

	Entity *enemy = enemies;

    while(x){

    	enemy->pxPos  = enemy->xPos;
    	enemy->pyPos  = enemy->yPos;
    	enemy->pstate = enemy->state;

        switch (enemy->state) {

            case ENEMY_STATE_ACTIVE:

            	if(enemy->type >= ENEMY_TYPE_WINDOW){

					enemy->xPos += enemy->xSpeed;

					if((enemy->xSpeed < 0 && enemy->xPos <= -1 * enemy->width) || (enemy->xSpeed > 0 && enemy->xPos >= MAX_X)){

						enemy->state = ENEMY_STATE_INACTIVE;

					}

					//Check walls
					if(enemy->xPos >= MIN_X && enemy->xPos <= MAX_X){

						tile = *(tilemap + (enemy->xPos + (enemy->xSpeed > 0 && enemy->xPos + enemy->width <= MAX_X ? enemy->width : 0))/4 + 20 * ((enemy->yPos + enemy->height)/8));


						if(enemy->lastTile < 44 && tile >= 44 && !(level == 1 && enemy->yPos == 40 && enemy->xSpeed < 0)){

							enemy->xSpeed *= -1;
							fliped = TRUE;

						}
						enemy->lastTile = tile;

					}


					//Fire
					if(cpct_rand() % 200 > 192 - level){

						enemy->cycles = 0;
						enemy->state = ENEMY_STATE_FIRE;

						if(!fliped && cpct_rand() % 2 == 1) enemy->xSpeed *= -1;
					}

            	}

            	//Check collisions

            	if(!protection && cpct_isKeyPressed(fire) && hero->state < HERO_STATE_HIT &&(

					 target->xPos + TARGET_W/2 >= enemy->xPos &&  target->xPos + TARGET_W/2 <= enemy->xPos + enemy->width &&
					 target->yPos + TARGET_H/2 >= enemy->yPos &&  target->yPos + TARGET_H/2 <= enemy->yPos + enemy->height)){

            		protection = TRUE;

					if(--enemy->hits == 0){

						enemy->state = ENEMY_STATE_EXPLOSION_A;
						enemy->cycles = 0;

						if(enemy->window < 100) windows[enemy->window] = FALSE;

						if(enemy->type > ENEMY_TYPE_BOTTLE) cpct_akp_SFXPlay(3, 15, 36, 0, 0, AY_CHANNEL_B);
						else{
							cpct_akp_SFXPlay(2, 15, 52, 0, 0, AY_CHANNEL_B);

						}

						score += 10;

						if(enemy->type == ENEMY_TYPE_MONEY) score += 90;
						else if(enemy->type == ENEMY_TYPE_COKE){

							if(lives < MAX_LIVES){

								lives++;
								drawLives();

							}
						}

					}

                }

                break;

            case ENEMY_STATE_EXPLOSION_A:

                enemy->state = ENEMY_STATE_EXPLOSION_B;

                if(enemy->type < ENEMY_TYPE_WINDOW){
                	enemy->xPos = enemy->xPos + enemy->width/2 - EXPLOSION_W/2;
                	enemy->yPos = enemy->yPos + enemy->height - EXPLOSION_H;
                }

                break;

            case ENEMY_STATE_EXPLOSION_B:

				if(enemy->cycles++ == 1){

					enemy->state = ENEMY_STATE_EXPLOSION_C;

				}

				break;

            case ENEMY_STATE_EXPLOSION_C:

            	if(enemy->type == ENEMY_TYPE_BARREL) generateGift(enemy, enemies);

                enemy->state = ENEMY_STATE_INACTIVE;
                if(--enemiesToKill < 0) enemiesToKill = 0;

                updateScoreboard();

                break;

        }


        enemy++; x--;
    }
    
    return protection;

}


void clearGameScreen(){

	u8* pvideo = cpct_getScreenPtr(g_scrbuffers[1], MIN_X, MIN_Y);
    
	cpct_drawSolidBox(pvideo, 255, 40, MAX_Y - MIN_Y);
	pvideo = cpct_getScreenPtr(g_scrbuffers[1], 40, MIN_Y);
	cpct_drawSolidBox(pvideo, 255, 40, MAX_Y - MIN_Y);

}


void moveBullets(Entity *hero, Bullet *bullet) {

    u8 x;

    for(x=0;x<MAX_BULLETS;x++){

    	bullet->pxPos 	= bullet->xPos;
    	bullet->pyPos 	= bullet->yPos;
    	bullet->pactive = bullet->active;

        if(bullet->active){

        	bullet->xPos += bullet->xSpeed;
        	bullet->yPos += bullet->ySpeed;

        	if(hero->state < HERO_STATE_HIT && bullet->yPos > MAX_Y - HERO_H + 8 && bullet->xPos + BULLET_W >= hero->xPos + 3 && bullet->xPos <= hero->xPos + HERO_W - 3){

        		hero->state = HERO_STATE_HIT;
        		hero->cycles = 0;
        		bullet->active = FALSE;
        		cpct_akp_SFXPlay(3, 15, 36, 0, 0, AY_CHANNEL_B);

        	}

        	if(hero->state >= HERO_STATE_HIT || bullet->xPos < MIN_X - BULLET_W || bullet->xPos >= MAX_X  || bullet->yPos >= MAX_Y - BULLET_H) bullet->active = FALSE;

        }

        bullet++;
    }

}

void drawBullets(Bullet *bullet, u8 draw) {
    
    u8 x;
    
    for(x=0;x<MAX_BULLETS;x++){
            
    	if(bullet->active && draw){

    		if(bullet->cycles < 2){

    			drawClippedSprite(G_bala1, bullet->xPos, bullet->yPos, BULLET_W, BULLET_H);

    		}
    		else{

    			drawClippedSprite(G_bala2, bullet->xPos, bullet->yPos, BULLET_W, BULLET_H);
    		}

    		if(++bullet->cycles == 4) bullet->cycles = 0;
    	}
        if(bullet->pactive && !draw) eraseClippedSprite(bullet->pxPos, bullet->pyPos, BULLET_W, BULLET_H);

        bullet++;
    }
}
